import { PageStateManager } from "../popup/utils/PageStateManager.js";
import { LoginManager } from "../popup/components/login/login.js";
import config from "../config/config.js";

// 消息提示函数
export function showMessage(text, type = "success", timer=4000) {
  const container = document.createElement("div");
  container.className = `message ${type}`;
  container.textContent = text;

  // 获取当前所有显示的消息容器
  const existingMessages = document.querySelectorAll('.message');
  const offset = existingMessages.length * 60; // 每个消息的垂直间距为60px

  // 设置新消息的垂直位置
  container.style.position = 'fixed';
  container.style.top = `${20 + offset}px`; // 初始位置为20px，每个新消息向下偏移60px
  container.style.left = '50%';
  container.style.transform = 'translateX(-50%)';

  document.body.appendChild(container);

  setTimeout(() => {
    container.remove();
    // 移除后，重新调整剩余消息的位置
    const remainingMessages = document.querySelectorAll('.message');
    remainingMessages.forEach((msg, index) => {
      msg.style.top = `${20 + index * 60}px`;
    });
  }, timer);
}

export function handleUnauthorized() {
  // token过期或未授权
  localStorage.removeItem(config.STORAGE_KEYS.TOKEN);
  // 跳转到popup页面并触发登录弹窗
  const currentPage = PageStateManager.instance.getCurrentPage();
  PageStateManager.instance.clearPageState();
  if (currentPage === "shopDetail") {
    const shopDetail = document.body.querySelector(".shop-detail-container");
    PageStateManager.hideComponent(shopDetail);
  } else if (currentPage === "memberRecharge") {
    const shopList = document.body.querySelector(".member-recharge-page");
    PageStateManager.hideComponent(shopList);
  } else if (currentPage === "timeSaleSetting") {
    const timeSaleSetting = document.body.querySelector(".time-sale-container");
    PageStateManager.hideComponent(timeSaleSetting);
  }
  LoginManager.instance.showLoginModal();
}

/** 获取下一个月的前一天 */
export function getNextMonthPrevDay(dateStr) {
  const parts = dateStr.split('/');
  const year = parseInt(parts[0], 10);
  const month = parseInt(parts[1], 10) - 1; // 月份转为0-based
  const day = parseInt(parts[2], 10);
  const date = new Date(year, month, day);
  
  const currentMonth = date.getMonth();
  date.setMonth(currentMonth + 1); // 先加一个月
  
  // 处理月份溢出（如1月31日加一个月后变成3月）
  if (date.getMonth() !== (currentMonth + 1) % 12) {
      // 获取目标月份的最后一天（currentMonth+2月的第0天）
      date.setTime(new Date(year, currentMonth + 2, 0).getTime());
  }
  
  date.setDate(date.getDate() - 1); // 再减一天
  
  // 格式化为yyyy/mm/dd
  const y = date.getFullYear();
  const m = String(date.getMonth() + 1).padStart(2, '0');
  const d = String(date.getDate()).padStart(2, '0');
  return `${y}/${m}/${d}`;
}