export class PageStateManager {
  static instance = null;

  constructor() {
    if (PageStateManager.c) {
      return PageStateManager.instance;
    }
    PageStateManager.instance = this;
  }

  // 保存当前页面状态
  saveCurrentPage(pageName) {
    localStorage.setItem("QDD_CURRENT_PAGE", pageName);
  }

  // 获取上次保存的页面状态
  getCurrentPage() {
    return localStorage.getItem("QDD_CURRENT_PAGE") || "home";
  }

  // 清除页面状态
  clearPageState() {
    localStorage.removeItem("QDD_CURRENT_PAGE");
  }

  static showComponent(component) {
    if (component) {
      component.classList.add("active");
    }
  }

  static hideComponent(component) {
    if (component) {
      component.classList.remove("active");
    }
  }
}
