import { LocalTempDataStorage } from "../../utils/localTempDataStorage.js";
import { PageStateManager } from "../../utils/PageStateManager.js";
import { showMessage } from "../../../utils/index.js";
import { PriceRangeManager } from "./priceRangeManager.js";
import { TimeSaleSettingService } from "../../../services/index.js";
import { BeginButtonManager } from "./BeginButtonManager.js";
// import { writeFile } from '../../utils/fileUtils.js';  // 我们需要创建这个工具函数

// 初始化本地临时数据存储和页面状态管理
const tempStorage = new LocalTempDataStorage();
const pageManager = new PageStateManager();
let priceRangeManager;
let syncClass;
let beginButtonManager;
export async function initTimeSaleSetting() {
  // 获取HTML内容
  const response = await fetch(
    chrome.runtime.getURL(
      "popup/components/timeSaleSetting/timeSaleSetting.html"
    )
  );
  const html = await response.text();

  // 插入到容器
  const container = document.getElementById("timeSaleSettingContainer");
  container.innerHTML = html;

  // 初始化价格区间管理器
  priceRangeManager = new PriceRangeManager();
  // 获取元素并绑定事件
  const timeSale = container.querySelector(".time-sale-container");
  // 获取元素并绑定事件
  const backButton = timeSale.querySelector(".back-button");
  // 返回按钮点击事件
  backButton.addEventListener("click", () => {
    timeSale.classList.remove("active");
    pageManager.saveCurrentPage("home"); // 返回时保存首页状态
  });
  syncClass = new SyncClass(priceRangeManager, pageManager, tempStorage);
  // 注册同步按钮的点击事件
  syncClass.registerSyncButton(timeSale);
  // 初始化开始按钮管理器
  beginButtonManager = new BeginButtonManager(
    priceRangeManager,
    tempStorage,
    syncClass
  );
  // 注册点击开始
  beginButtonManager.registerBeginButton(timeSale);
  // 展开点击事件
  const priceSetContainer = document.querySelector(
    "#price-setting-container .collapse-btn"
  );
  const priceContainer = document.querySelector(
    "#start-container .collapse-btn"
  );
  priceSetContainer.addEventListener("click", () => {
    const hasSync = syncClass.getHasSync();
    if (!hasSync) {
      showMessage("请先同步商品", "error");
    }
  });
  priceContainer.addEventListener("click", () => {
    const hasSync = syncClass.getHasSync();
    if (!hasSync) {
      showMessage("请先同步商品", "error");
    }
  });
  // 保存优惠规则
  const saveButton = container.querySelector(".save-btn");
  saveButton.addEventListener("click", async () => {
    syncClass.saveData();
  });
  // 重置按钮
  const resetButton = container.querySelector(".reset-btn");
  resetButton.addEventListener("click", async () => {
    syncClass.resetData();
  });
  // 点击修改按钮
  const modifyButton = container.querySelector(".modify-btn");
  modifyButton.addEventListener("click", async () => {
    const footerOperateButtons = document.querySelector(
      ".footer-operate-buttons"
    );
    footerOperateButtons.classList.remove("disabled");
    modifyButton.classList.add("disabled");
    syncClass.togglePriceRangeControls(true);
  });

  return {
    show() {
      timeSale.classList.add("active");
    },
    hide() {
      timeSale.classList.remove("active");
    },
  };
}

class SyncClass {
  constructor(priceRangeManager, pageManager, tempStorage) {
    this.priceRangeManager = priceRangeManager;
    this.pageManager = pageManager;
    this.tempStorage = tempStorage;
    this.hasSync = false;
  }

  // 获取是否同步
  getHasSync() {
    return this.hasSync;
  }
  // 注册同步按钮的点击事件
  registerSyncButton(timeSale) {
    const syncButton = timeSale.querySelector(".sync-btn");
    const listener = async () => {
      // 保存当前页面状态，这样重新打开插件时会回到这个页面
      this.pageManager.saveCurrentPage("timeSaleSetting");
      // 执行同步操作
      await this.handleSync();
    };
    syncButton.addEventListener("click", listener);
  }

  // 更新商品数量
  updateGoodsCount(productsCount) {
    const goodsCount = document.getElementById("goods-count");
    if (goodsCount) {
      goodsCount.innerText = productsCount;
    }
  }

  // 同步按钮点击事件
  async handleSync() {
    this.updateSyncButton("asyning", true, true);
    const that = this;
    // 获取当前活动标签页
    const [activeTab] = await chrome.tabs.query({
      active: true,
      currentWindow: true,
    });

    // 在当前标签页更新URL
    await chrome.tabs.update(activeTab.id, {
      url: "https://qsm.qoo10.jp/GMKT.INC.Gsm.Web/Product/ProductListSummary.aspx",
    });

    // 第一阶段：获取用户基本信息
    chrome.tabs.onUpdated.addListener(async function phase1Listener(
      tabId,
      info
    ) {
      if (tabId === activeTab.id && info.status === "complete") {
        chrome.tabs.onUpdated.removeListener(phase1Listener);

        // 执行内容脚本获取基本信息
        const results = await chrome.scripting.executeScript({
          target: { tabId: activeTab.id },
          world: "MAIN",
          function: function () {
            const avatarImg = document.querySelector(".info .img img");
            const shopName = document.querySelector(".info .id .shop");
            const userId = document.querySelector(".info .id strong");
            const langDom = document.body.querySelector(
              ".slt_wrap>.lang>a>span"
            );

            if (window.ChangeLang && langDom?.innerText !== "简体中文") {
              window.ChangeLang("zh-cn");
            }

            return {
              avatarUrl: avatarImg?.src,
              shopName: shopName?.textContent.replace(/[()]/g, "").trim(),
              userId: userId?.textContent,
            };
          },
        });

        const userInfo = results[0]?.result;
        if (!userInfo || !userInfo.userId) {
          that.updateSyncButton("asynerror", false, false);
          return showMessage("获取店铺信息失败", "error");
        }

        // 验证接口
        const checkTaskRes = await TimeSaleSettingService.checkSyncTask({
          platformUserId: userInfo.userId,
        });
        const { data: checkTaskData, message } = checkTaskRes || {};
        const { can_sync, task_id } = checkTaskData || {};
        if (!can_sync) {
          that.updateSyncButton("asynerror", false, false);
          TimeSaleSettingService.completeSyncTask({
            task_id,
            platform_user_id: userInfo.userId,
          });
          return showMessage(message, "error");
        }
        // 第二阶段：获取商品数据
        // 执行内容脚本获取商品数据
        const codeResults = await chrome.scripting.executeScript({
          target: { tabId: activeTab.id },
          world: "MAIN",
          function: async function () {
            function getTimeRange(monthsOffset) {
              const now = new Date();
              let monthsAgo = new Date(now);
              monthsAgo.setMonth(now.getMonth() - monthsOffset);

              function formatDate(date) {
                const year = date.getFullYear();
                const month = String(date.getMonth() + 1).padStart(2, "0");
                const day = String(date.getDate()).padStart(2, "0");
                const hours = String(date.getHours()).padStart(2, "0");
                const minutes = String(date.getMinutes()).padStart(2, "0");
                const seconds = String(date.getSeconds()).padStart(2, "0");
                return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
              }

              const dt_to = formatDate(now);
              const dt_from = formatDate(monthsAgo);
              return { dt_from, dt_to };
            }
            function stringToNumber(str) {
              if (typeof str !== "string") {
                throw new Error("输入必须是字符串");
              }
              const cleanedStr = str.replace(/,/g, "");
              const result = Number(cleanedStr);
              if (isNaN(result)) {
                throw new Error("输入包含非法字符，无法转换为数字");
              }
              return result;
            }
            async function getProductCodes() {
              let date = new Date();
              let { dt_from, dt_to } = getTimeRange(60);
              let codeLists = [];
              const onSaleCnt = document.getElementById("on_sale_cnt");
              totalProducts = stringToNumber(onSaleCnt.innerText);
              if (ProductSummary) {
                totalProducts = ProductSummary.statSummary[1];
              }
              let query = {
                sell_cust_no: GMKT.CustInfo.cust_no,
                gdlc_cd: null,
                gdmc_cd: null,
                gdsc_cd: null,
                dt_type: "0",
                dt_from,
                dt_to,
                gd_stats: "OS,SO",
                srch_type1: "0",
                srch_value1: "",
                srch_type2: "0",
                srch_value2: "",
                srch_type3: "0",
                srch_value3: "",
                disc_all_yn: "Y",
                basic_disc_yn: "Y",
                time_sale_yn: "Y",
                daily_deal_yn: "Y",
                group_buy_yn: "Y",
                no_disc_yn: "Y",
                order_type: "0",
                page_no: "1",
                page_size: "500",
                lang_cd: "zh-cn",
                svc_nation_cd: "JP",
                gd_sub_type: "",
                move_seller: "N",
                reg_limit_seller: "N",
                megawari_promotion_yn: "A",
                superpoint_promotion_yn: "A",
                ___cache_expire___: date.toString(),
              };

              async function fetchAllProducts(totalProducts) {
                let currentPage = 1;
                async function fetchPage() {
                  query.page_no = currentPage.toString();
                  // 添加1秒延迟
                  await new Promise((resolve) => setTimeout(resolve, 1000));
                  const res = await new Promise((resolve) => {
                    Public.AsyncCallWebServiceToGetJSON(
                      "swe_NewGoodsBizService.asmx",
                      "GetSellerProductList",
                      JSON.stringify(query),
                      function (res) {
                        resolve(res);
                      }
                    );
                  });

                  const { Rows } = res || {};
                  const curCodelists = Rows?.map((item) => item.gd_no) || [];
                  codeLists = codeLists.concat(curCodelists);

                  if (
                    codeLists.length < totalProducts &&
                    curCodelists.length > 0
                  ) {
                    currentPage++;
                    await fetchPage();
                  }
                }
                await fetchPage();
              }

              if (totalProducts) {
                await fetchAllProducts(totalProducts);
              }
              return codeLists;
            }

            return await getProductCodes();
          },
        });

        const codeLists = codeResults[0]?.result || [];
        if (codeLists.length < 1) {
          that.updateSyncButton("asynerror", false, false);
          TimeSaleSettingService.completeSyncTask({
            task_id,
            platform_user_id: userInfo.userId,
          });
          return showMessage("获取商品数据失败", "error");
        }

        // 更新店铺信息
        that.updateStoreInfo({
          ...userInfo,
          codeLists,
        });

        // 执行后续操作
        const addProductRes = await that.handleApiBatchAddProducts({
          userId: userInfo.userId,
          codeLists,
        });
        if (!addProductRes) {
          that.updateSyncButton("asynerror", false, false);
          TimeSaleSettingService.completeSyncTask({
            task_id,
            platform_user_id: userInfo.userId,
          });
          return;
        }
        try {
          const { sync_count } = await TimeSaleSettingService.completeSyncTask({
            task_id,
            platform_user_id: userInfo.userId,
          });

          that.getStoreProductsInfo(userInfo.userId);
          that.updateGoodsCount(sync_count);
          await that.getDiscountData(userInfo.userId);
          that.expandDiscountSettings();
          that.updateSyncButton("asyned", false, false);
          that.hasSync = true;
          showMessage(`同步完成`, "success");
        } catch (error) {
          that.updateSyncButton("asynerror", false, false);
          TimeSaleSettingService.completeSyncTask({
            task_id,
            platform_user_id: userInfo.userId,
          });
          console.error(error);
        }
      }
    });
  }

  async handleApiBatchAddProducts({ codeLists, userId }) {
    const batchNum = 300;
    const batchCount = Math.ceil(codeLists.length / batchNum);
    let failedShopCodes = [];
    for (let i = 0; i < batchCount; i++) {
      const shop_Code = codeLists.slice(i * batchNum, (i + 1) * batchNum);
      try {
        const checkTaskRes = await TimeSaleSettingService.batchAddProducts({
          platform_user_id: userId,
          shop_Code,
        });
        const { failed } = checkTaskRes || {};
        const { details } = failed || {};
        failedShopCodes.push(...details);
      } catch (error) {
        console.error(error);
        return false;
      }
    }
    if (failedShopCodes.length > 0) {
      for (let i = 0; i < 3; i++) {
        try {
          const checkTaskRes = await TimeSaleSettingService.batchAddProducts({
            platform_user_id: userId,
            shop_Code: failedShopCodes,
          });
          failedShopCodes = [];
          const { failed } = checkTaskRes || {};
          const { details } = failed || {};
          if (details && details.length > 0) {
            failedShopCodes = details;
          } else {
            break;
          }
        } catch (error) {
          console.error(error);
          return false;
        }
      }
    }
    return true;
  }

  /**
   * 控制价格区间卡片中所有按钮和输入框的状态
   * @param {boolean} enable - true: 恢复正常状态，false: 隐藏按钮并禁用输入框
   */
  togglePriceRangeControls(enable) {
    // 获取所有的价格区间行
    const priceRangeRows = document.querySelectorAll(".price-range-row");
    const limitSettingCard = document.querySelector(".limit-settings-card");

    if (limitSettingCard) {
      const inputs = limitSettingCard.querySelectorAll("input");
      if (enable) {
        inputs.forEach((input) => {
          input.disabled = false; // 启用输入框
          input.style.border = ""; // 恢复边框样式
        });
      } else {
        inputs.forEach((input) => {
          input.disabled = true; // 禁用输入框
          input.style.border = "none"; // 移除边框样式
        });
      }
    }
    priceRangeRows.forEach((row) => {
      // 获取当前行中的所有按钮
      const buttons = row.querySelectorAll("button");
      // 获取当前行中的所有输入框
      const inputs = row.querySelectorAll("input");

      if (enable) {
        // 如果传入 true，恢复按钮和输入框的正常状态
        buttons.forEach((button) => {
          button.style.display = ""; // 显示按钮
        });

        inputs.forEach((input) => {
          input.disabled = false; // 启用输入框
          input.style.border = ""; // 恢复边框样式
        });
      } else {
        // 如果传入 false，隐藏按钮并禁用输入框
        buttons.forEach((button) => {
          button.style.display = "none"; // 隐藏按钮
        });

        inputs.forEach((input) => {
          input.disabled = true; // 禁用输入框
          input.style.border = "none"; // 移除边框样式
        });
      }
    });
  }

  // 新增函数：更新同步按钮状态
  updateSyncButton(status, isDisabled, isLoading) {
    const syncButton = document.querySelector(".sync-btn");
    syncButton.disabled = isDisabled;
    if (isLoading) {
      syncButton.classList.add("loading");
    } else {
      syncButton.classList.remove("loading");
    }
    if (status === "asynerror") {
      syncButton.textContent = "同步失败，点击重新同步";
      syncButton.classList.add("failed");
    } else if (status === "asyning") {
      syncButton.textContent = "同步中";
    } else if (status === "asyned") {
      syncButton.textContent = "同步完成";
      syncButton.classList.add("completed");
      syncButton.classList.remove("failed");
    } else {
      syncButton.textContent = "同步商品";
    }
  }

  // 渲染限时特价设置内容
  renderSaleSettings(data, container) {
    // 填充价格区间
    this.priceRangeManager.setRangeData(data?.priceRules);
    // 填充限制设置
    const limitSettingsCard = container.querySelector(".limit-settings-card");
    const inputs = limitSettingsCard.querySelectorAll(".limit-row input");
    inputs[0].value = data?.totalLimit || null;
    inputs[1].value = data?.perPersonLimit || null;
  }

  // 获取加载优化规则数据
  async getDiscountData() {
    const userId = this.tempStorage.getShopId();
    if (userId) {
      try {
        const datas = await TimeSaleSettingService.getSaleRule();
        if (datas?.priceRules && datas?.priceRules?.length > 0) {
          this.modifyBtnVisible();
        }
        this.priceRangeManager.setSaleRuleDatas(datas);
        const container = document.querySelector("#price-container");
        this.renderSaleSettings(datas, container);
      } catch (error) {
        showMessage(error.message || "获取设置失败", "error");
      }
    }
  }

  modifyBtnVisible() {
    const footerOperateButtons = document.querySelector(
      ".footer-operate-buttons"
    );
    const modifyBtn = document.querySelector(".modify-btn");

    if (footerOperateButtons) {
      footerOperateButtons.classList.add("disabled");
      modifyBtn.classList.remove("disabled");
      this.togglePriceRangeControls(false);
    }
  }

  // 设置展开优惠设置
  async expandDiscountSettings() {
    const priceSetContainer = document.getElementById(
      "price-setting-container"
    );
    const priceContainer = document.getElementById("start-container");
    priceSetContainer.classList.remove("collapsed");
    priceContainer.classList.remove("collapsed");
  }

  // 更新店铺信息
  updateStoreInfo(data) {
    const avatar = document.querySelector(".store-avatar");
    const storeId = document.querySelector(".store-id");
    const storeName = document.querySelector(".store-name");

    // 更新UI
    if (data.avatarUrl) {
      avatar.classList.add("loaded");
      avatar.innerHTML = `<img src="${data.avatarUrl}" alt="店铺头像">`;
    }

    if (data.userId) {
      storeId.textContent = data.userId;
    }

    if (data.shopName) {
      storeName.textContent = `店铺名：${data.shopName}`;
    }

    // 保存数据
    this.tempStorage.setModuleData("timeSaleSetting", "storeInfo", data);
  }

  /** 获取店铺商品和规则信息 */
  async getStoreProductsInfo(userId) {
    const {
      data: productsRes,
      paid,
      total_used,
    } = (await TimeSaleSettingService.getShopDiscountPrepare(userId)) || {};
    console.log("paid, total_used", paid, total_used);
    // 检查付费状态
    const { products } = productsRes || {};

    // 保存付费状态，供其他方法使用
    this.isPaidUser = paid === 1;
    this.hasFreeUsage = total_used < 50;

    const { product_codes, stats } = products || {};
    if (products) {
      this.priceRangeManager.setProductsDatas(products);
      if (stats) {
        const { total, pending, success, failed } = stats;
        document.getElementById("total-num").innerText = total;
        document.getElementById("pending-num").innerText = pending;
        document.getElementById("success-num").innerText = success;
        document.getElementById("failed-num").innerText = failed;
        showMessage("商品信息已更新", "success");
      }
    }
    if (!this.isPaidUser && !this.hasFreeUsage) {
      return false;
    }
    return true;
  }

  // 调用保存接口
  async saveData() {
    try {
      const userId = tempStorage.getShopId();
      const rangeData = this.priceRangeManager.getAllRangeData();
      const priceRange = this.priceRangeManager.getLimitSettingsData();
      const priceRules = rangeData.map((item) => {
        return {
          startPrice: Number(item.startPrice),
          endPrice: Number(item.endPrice),
          discountAmount: Number(item.discount),
        };
      });
      const params = {
        userSettingId: userId,
        priceRules,
        totalLimit: Number(priceRange.quantityLimit),
        perPersonLimit: Number(priceRange.perPersonLimit),
      };
      await TimeSaleSettingService.createSaleRule(params);
      // 获取折扣加载数据
      await this.getDiscountData(userId);
      showMessage("保存成功", "success");
      this.modifyBtnVisible();
    } catch (error) {
      showMessage(error.message || "保存失败", "error");
    }
  }

  // 调用重置按钮
  async resetData() {
    try {
      const userId = tempStorage.getShopId();
      await TimeSaleSettingService.resetSaleRule();
      // 获取折扣加载数据
      await this.getDiscountData(userId);
      showMessage("重置成功", "success");
    } catch (error) {
      showMessage(error.message || "重置失败", "error");
    }
  }
}
