export class PriceRangeManager {
    constructor() {
        this.priceRangeCard = document.querySelector('.price-range-card');
        this.limitSettingsCard = document.querySelector('.limit-settings-card'); // 添加对商品限制设置卡片的引用
        this.initEvents();
        this.saleRuleDatas = null
        this.products = null;
        this.currentProductId = 0;
    }

    // 初始化事件监听
    initEvents() {
        const addBtn = this.priceRangeCard.querySelector('.add-range-btn');
        addBtn.addEventListener('click', () => this.addNewRow());
    }

    // 添加新行
    addNewRow() {
        const newRow = document.createElement('div');
        newRow.className = 'price-range-row';
        // 使用删除按钮模板
        newRow.innerHTML = this.getRowTemplate(false);
        this.priceRangeCard.appendChild(newRow);

        // 为删除按钮绑定事件
        const deleteBtn = newRow.querySelector('.delete-range-btn');
        deleteBtn.addEventListener('click', () => this.deleteRow(newRow));
    }

    // 删除行
    deleteRow(row) {
        this.priceRangeCard.removeChild(row);
    }

    // 获取行模板
    getRowTemplate(isFirst = true) {
        const buttonTemplate = isFirst ? 
            `<button class="add-range-btn">
                <img src="../assets/mainimages/addprice.png" alt="添加价格区间">
            </button>` :
            `<button class="delete-range-btn">
                <img src="../assets/mainimages/trash.png" alt="删除价格区间">
            </button>`;

        return `
            <div class="price-input-group">
                <input type="text" placeholder="请输入 円">
                <span class="separator">-</span>
                <input type="text" placeholder="请输入 円">
            </div>
            <div class="discount-input">
                <span>优惠金额：</span>
                <input type="text" placeholder="请输入优惠金额">
            </div>
            ${buttonTemplate}
        `;
    }

    // 获取所有价格区间数据
    getAllRangeData() {
        const rows = this.priceRangeCard.querySelectorAll('.price-range-row');
        return Array.from(rows).map(row => {
            const inputs = row.querySelectorAll('input');
            return {
                startPrice: inputs[0].value,
                endPrice: inputs[1].value,
                discount: inputs[2].value
            };
        });
    }

    // 设置价格区间数据
    setRangeData(data) {
        // 清除现有行
        while (this.priceRangeCard.children.length > 1) {
            this.priceRangeCard.removeChild(this.priceRangeCard.lastChild);
        }
        let newData = data;
        if(!data || data.length === 0){
            newData = [{
                startPrice: null,
                endPrice: null,
                discountAmount: null
            }]
        }

        // 添加新数据行
        newData?.forEach((item, index) => {
            if (index > 0) this.addNewRow();
            const rows = this.priceRangeCard.querySelectorAll('.price-range-row');
            const currentRow = rows[index];
            const inputs = currentRow.querySelectorAll('input');
            inputs[0].value = item?.startPrice;
            inputs[1].value = item?.endPrice;
            inputs[2].value = item?.discountAmount;
        });
    }

    // 获取商品限制设置数据
    getLimitSettingsData() {
        const inputs = this.limitSettingsCard.querySelectorAll('.limit-row input');
        return {
            quantityLimit: inputs[0].value,
            perPersonLimit: inputs[1].value,
        };
    }

    // 设置商品限制设置数据
    setLimitSettingsData(data) {
        const quantityInput = this.limitSettingsCard.querySelector('.limit-row input[placeholder="请输入"]:first-child');
        const perPersonInput = this.limitSettingsCard.querySelector('.limit-row input[placeholder="请输入"]:last-child');
        quantityInput.value = data.quantityLimit;
        perPersonInput.value = data.perPersonLimit;
    }

    // 获取优惠规则数据
    getSaleRuleDatas(){
        return this.saleRuleDatas;
    }
    // 设置优惠规则数据
    setSaleRuleDatas(datas){
        this.saleRuleDatas = datas;
    }

    // 获取店铺商品
    getProductsDatas(){
        return this.products;
    }
    // 设置店铺商品
    setProductsDatas(datas){
        this.products = datas;
    }

    // 获取当前商品ID
    getCurrentProductId(){
        const { product_codes } = this.products || {}
        if(product_codes && product_codes.length > 0){
            return product_codes[0]
        }
        return null
    }
}
