import { LoginManager } from "../../components/login/login.js";

export async function initMemberRecharge() {
  const memberRecharge = document.getElementById("memberRechargeContainer");
  const closePages = () => {
    memberRecharge
      .querySelector(".member-recharge-page")
      .classList.remove("active");
  };
  const initialization = async () => {
    const loginManager = LoginManager.getInstance();
  };

  try {
    // 加载HTML内容
    const response = await fetch(
      "components/memberRecharge/memberRecharge.html"
    );
    const html = await response.text();
    memberRecharge.innerHTML = html;

    const memberRechargePage = memberRecharge.querySelector(
      ".member-recharge-page"
    );
    const backButton = memberRechargePage.querySelector(".back-button");
    const rechargeOptions =
      memberRechargePage.querySelectorAll(".recharge-option");
    const rechargeButton = memberRechargePage.querySelector(".recharge-button");

    // 返回按钮点击事件
    backButton.addEventListener("click", () => {
      closePages();
    });

    // 充值选项点击事件
    rechargeOptions.forEach((option) => {
      option.addEventListener("click", () => {
        // 移除其他选项的选中状态
        rechargeOptions.forEach((opt) => opt.classList.remove("selected"));
        // 添加当前选项的选中状态
        option.classList.add("selected");
        // 更新按钮文字
        rechargeButton.textContent = "确认充值";
        rechargeButton.style.background = "#6B7AFF";
      });
    });

    // 充值按钮点击事件
    rechargeButton.addEventListener("click", () => {
      const selectedOption = memberRechargePage.querySelector(
        ".recharge-option.selected"
      );
      if (selectedOption) {
        // TODO: 处理充值逻辑
        alert("充值成功！");
      }
    });

    return {
      show: () => {
        memberRecharge
          .querySelector(".member-recharge-page")
          .classList.add("active");
        initialization();
      },
      hide: () =>
        memberRecharge
          .querySelector(".member-recharge-page")
          .classList.remove("active"),
    };
  } catch (error) {
    console.error("Error initializing member recharge:", error);
  }
}
