import config from '../config/config.js';

class OptionsManager {
    constructor() {
        this.init();
    }

    init() {
        this.loadCurrentSettings();
        this.bindEvents();
    }

    loadCurrentSettings() {
        // 加载环境设置
        const envSelect = document.getElementById('environment');
        envSelect.value = config.currentEnv;

        // 加载超时设置
        const timeoutInput = document.getElementById('apiTimeout');
        timeoutInput.value = config.TIMEOUT;

        // 加载其他设置
        const autoLoginCheckbox = document.getElementById('autoLogin');
        autoLoginCheckbox.checked = localStorage.getItem('autoLogin') === 'true';
    }

    bindEvents() {
        // 保存按钮事件
        document.getElementById('saveButton').addEventListener('click', () => {
            this.saveSettings();
        });

        // 重置按钮事件
        document.getElementById('resetButton').addEventListener('click', () => {
            this.resetSettings();
        });
    }

    async saveSettings() {
        try {
            const settings = {
                environment: document.getElementById('environment').value,
                apiTimeout: parseInt(document.getElementById('apiTimeout').value),
                autoLogin: document.getElementById('autoLogin').checked
            };

            // 保存到 storage
            await chrome.storage.sync.set(settings);
            
            // 更新本地存储
            localStorage.setItem('autoLogin', settings.autoLogin);

            alert('设置已保存');
        } catch (error) {
            console.error('保存设置失败:', error);
            alert('保存设置失败');
        }
    }

    resetSettings() {
        if (confirm('确定要重置所有设置吗？')) {
            // 重置为默认值
            document.getElementById('environment').value = 'development';
            document.getElementById('apiTimeout').value = 5000;
            document.getElementById('autoLogin').checked = false;

            // 保存默认设置
            this.saveSettings();
        }
    }
}

// 初始化选项管理器
new OptionsManager(); 