import Request from"../utils/request.js";import{showMessage}from"../utils/index.js";class TimeSaleSettingService{static async createSaleRule(s){try{const e=await Request.post("/discount/rules",s);if(e.success)return e.data;throw showMessage(e.message||"创建优惠规则失败","error"),new Error(e.message||"创建优惠规则失败")}catch(s){throw showMessage(s||"创建优惠规则失败","error"),console.error("创建优惠规则失败:",s),s}}static async updateSaleRule(s,e){try{const r=await Request.put(`/discount/rules/${s}`,e);if(r.success)return r.data;throw showMessage(r.message||"更新优惠规则失败","error"),new Error(r.message||"更新优惠规则失败")}catch(s){throw showMessage(s||"更新优惠规则失败","error"),console.error("更新优惠规则失败:",s),s}}static async getSaleRule(){try{const s=await Request.get("/discount/rules");if(s.success)return s.data;throw showMessage(s.message||"获取优惠规则失败","error"),new Error(s.message||"获取优惠规则失败")}catch(s){throw showMessage(s||"获取优惠规则失败","error"),console.error("获取优惠规则失败:",s),s}}static async resetSaleRule(){try{const s=await Request.delete("/discount/rules");if(s.success)return s.data;throw showMessage(s.message||"重置优惠规则失败","error"),new Error(s.message||"重置优惠规则失败")}catch(s){throw showMessage(s||"重置优惠规则失败","error"),console.error("重置优惠规则失败:",s),s}}static async startSyncTask(s){try{const e=await Request.post("/shop/sync/start",{platformShopId:s});if(e.success)return e;throw showMessage(e.message||"开始同步任务失败","error"),new Error(e.message||"开始同步任务失败")}catch(s){throw showMessage(s||"开始同步任务失败","error"),console.error("开始同步任务失败:",s),s}}static async getTaskStatus(s){try{const e=await Request.get(`/shop/sync/status?taskId=${s}`);if(e.success)return e.data;throw showMessage(e.message||"查询任务状态失败","error"),new Error(e.message||"查询任务状态失败")}catch(s){throw showMessage(s||"查询任务状态失败","error"),console.error("查询任务状态失败:",s),s}}static async getTaskResult(s){try{const e=await Request.get(`/shop/sync/result?taskId=${s}`);if(e.success)return e.data;throw showMessage(e.message||"获取任务结果失败","error"),new Error(e.message||"获取任务结果失败")}catch(s){throw showMessage(s||"获取任务结果失败","error"),console.error("获取任务结果失败:",s),s}}static async getShopDiscountPrepare(s){try{const e=await Request.get(`/shop/discount/prepare?platformShopId=${s}`);if(e.success)return e;throw showMessage(e.message||"获取店铺商品列表、优惠规则和设置状态统计失败","error"),new Error(e.message||"获取店铺商品列表、优惠规则和设置状态统计失败")}catch(s){throw showMessage(s||"获取店铺商品列表、优惠规则和设置状态统计失败","error"),console.error("获取店铺商品列表、优惠规则和设置状态统计失败:",s),s}}static async updateShopDiscountCallback(s){try{const e=await Request.post("/shop/discount/callback",s);if(e.success)return e.data;throw showMessage(e.message||"更新单个商品的优惠设置状态失败","error"),new Error(e.message||"更新单个商品的优惠设置状态失败")}catch(s){throw showMessage(s||"更新单个商品的优惠设置状态失败","error"),console.error("更新单个商品的优惠设置状态失败:",s),s}}static async checkSyncTask(s){try{let e="/products/sync/check";const r=[];s?.platformUserId&&r.push(`platform_user_id=${s.platformUserId}`),s?.taskId&&r.push(`task_id=${s.taskId}`),r.length>0&&(e+=`?${r.join("&")}`);const t=await Request.get(e);if(t.success)return t;throw showMessage(t.message||"检查同步商品任务状态失败","error"),new Error(t.message||"检查同步商品任务状态失败")}catch(s){throw showMessage(s||"批量添加商品失败","error"),console.error("检查同步商品任务状态失败:",s),s}}static async batchAddProducts(s){try{if(!s.platform_user_id||!s.shop_Code||!Array.isArray(s.shop_Code))throw new Error("请提供平台用户ID和商品代码列表");if(0===s.shop_Code.length)throw new Error("商品代码列表不能为空");if(s.shop_Code.length>500)throw new Error("单次处理商品数量不能超过500条");const e=await Request.post("/products/batch",s);if(e.success)return e.data;throw showMessage(e.message||"批量添加商品失败","error"),new Error(e.message||"批量添加商品失败")}catch(s){throw showMessage(s||"批量添加商品失败","error"),console.error("批量添加商品失败:",s),s}}static async completeSyncTask(s){try{if(!s.task_id||!s.platform_user_id)throw new Error("请提供正确的任务ID和平台用户ID");const e=await Request.post("/products/sync/complete",s);if(e.success)return e.data;throw showMessage(e.message||"完成同步任务失败","error"),new Error(e.message||"完成同步任务失败")}catch(s){throw showMessage(s||"完成同步任务失败","error"),console.error("完成同步任务失败:",s),s}}}export default TimeSaleSettingService;