import Request from"../utils/request.js";import config from"../config/config.js";import{showMessage}from"../utils/index.js";class AuthService{static async register(e){try{const t=await Request.post("/auth/register",e);if(t.success)return t.data;throw showMessage(t.message||"注册失败","error"),new Error(t.message||"注册失败")}catch(e){throw showMessage(e||"注册失败","error"),console.error("注册失败:",e),e}}static async login(e){try{const t=await Request.post("/auth/login",e);if(t.success&&t.data)return localStorage.setItem(config.STORAGE_KEYS.TOKEN,t.data.token),localStorage.setItem(config.STORAGE_KEYS.USER_INFO,JSON.stringify(t.data.user)),t.data;throw showMessage(t.message||"登录失败","error"),new Error(t.message||"登录失败")}catch(e){throw showMessage(e||"登录失败","error"),console.error("Login failed:",e),e}}static async logout(){try{await Request.post("/auth/logout")}finally{localStorage.removeItem(config.STORAGE_KEYS.TOKEN),localStorage.removeItem(config.STORAGE_KEYS.USER_INFO),localStorage.removeItem(config.STORAGE_KEYS.REMEMBER_PASSWORD)}}static async getCurrentUser(){try{return await Request.get("/auth/user")}catch(e){throw console.error("Get current user failed:",e),e}}static isLoggedIn(){return!!localStorage.getItem(config.STORAGE_KEYS.TOKEN)}static getUserInfo(){return localStorage.getItem(config.STORAGE_KEYS.USER_INFO)}static saveRememberPassword(e){if(!e.username||!e.password)return;const t={username:e.username,password:e.password,timestamp:(new Date).getTime()};localStorage.setItem(config.STORAGE_KEYS.REMEMBER_PASSWORD,JSON.stringify(t))}static getRememberPassword(){const e=localStorage.getItem(config.STORAGE_KEYS.REMEMBER_PASSWORD);if(!e)return null;try{return JSON.parse(e)}catch(e){return console.error("Parse remembered password failed:",e),null}}static clearRememberPassword(){localStorage.removeItem(config.STORAGE_KEYS.REMEMBER_PASSWORD)}}export default AuthService;