import{AuthService}from"../../../services/index.js";export class LoginManager{static instance=null;static getInstance(){return LoginManager.instance||(LoginManager.instance=new LoginManager),LoginManager.instance}constructor(){console.log("LoginManager constructor called"),this.init()}async init(){try{await this.loadLoginTemplate(),console.log("Template loaded"),this.initEventListeners(),console.log("Events initialized"),this.checkLoginStatus(),console.log("Login status checked")}catch(e){console.error("Initialization failed:",e)}}async loadLoginTemplate(){console.log("Loading template...");try{const e=chrome.runtime.getURL("popup/components/login/login.html"),t=await fetch(e),o=await t.text();document.body.insertAdjacentHTML("beforeend",o);const n=document.createElement("link");n.rel="stylesheet",n.href=chrome.runtime.getURL("popup/components/login/login.css"),document.head.appendChild(n),console.log("Template and styles loaded")}catch(e){console.error("Template loading failed:",e)}}initEventListeners(){const e=document.querySelector(".login-btn")||document.getElementById("loginButton");e&&e.addEventListener("click",(()=>{console.log("Login button clicked"),this.showLoginModal()}));const t=document.getElementById("logoutButton");t&&t.addEventListener("click",(()=>{this.logout()}));const o=document.getElementById("closeLogin");o&&o.addEventListener("click",(e=>{console.log("Close button clicked"),e.preventDefault(),e.stopPropagation(),this.hideLoginModal()}));const n=document.querySelector(".login-container");n&&n.addEventListener("click",(e=>{e.stopPropagation()})),document.getElementById("loginForm").addEventListener("submit",(e=>{e.preventDefault(),this.handleLogin()}));const s=document.getElementById("togglePassword");s&&s.addEventListener("click",(()=>{const e=document.getElementById("password"),t=s.querySelector("img");"password"===e.type?(e.type="text",t.src="../assets/mainimages/eye-open.png"):(e.type="password",t.src="../assets/mainimages/eye-close.png")}))}showLoginModal(){console.log("Showing login modal");const e=document.getElementById("loginModal");if(console.log("Modal found:",!!e),e){e.style.display="block",console.log("Modal display style set to:",e.style.display);const t=window.getComputedStyle(e);console.log("Computed display style:",t.display),console.log("Modal z-index:",t.zIndex),console.log("Modal position:",t.position)}}hideLoginModal(){const e=document.getElementById("loginModal");e&&(e.style.display="none")}validateForm(){let e=!0;const t=document.getElementById("username"),o=document.getElementById("password");return t.value.trim()?this.clearFieldError(t):(this.showFieldError(t,"请输入用户名"),e=!1),o.value.trim()?this.clearFieldError(o):(this.showFieldError(o,"请输入密码"),e=!1),e}showFieldError(e,t){const o=e.closest(".form-group");o.classList.add("error"),o.querySelector(".error-tip").textContent=t}clearFieldError(e){e.closest(".form-group").classList.remove("error")}async handleLogin(){if(!this.validateForm())return;const e=document.getElementById("username").value,t=document.getElementById("password").value,o=document.getElementById("rememberPassword").checked,n=document.querySelector(".login-submit-btn");n.disabled=!0,n.textContent="登录中...";try{const n=await AuthService.login({username:e,password:t});o?AuthService.saveRememberPassword({username:e,password:t}):AuthService.clearRememberPassword(),this.hideLoginModal(),this.updateUIAfterLogin(n.user)}catch(e){this.showError(e.message||"登录失败，请稍后重试")}finally{n.disabled=!1,n.textContent="登 录"}}showError(e){const t=document.getElementById("errorMessage");t.textContent=e,t.style.display="block"}checkLoginStatus(){AuthService.isLoggedIn()&&this.updateUIAfterLogin();try{const e=AuthService.getRememberPassword();if(e){const t=document.getElementById("username"),o=document.getElementById("password"),n=document.getElementById("rememberPassword");t&&o&&n&&(t.value=e.username,o.value=e.password,n.checked=!0,console.log("自动填充保存的凭证"))}}catch(e){console.error("获取保存的凭证失败:",e)}}updateUIAfterLogin(e){const t=document.getElementById("loginButton"),o=document.getElementById("registerButton");t&&(t.style.display="none"),o&&(o.style.display="none");const n=document.getElementById("logoutButton");if(n){n.style.display="block";document.getElementById("avatarDropdown").classList.toggle("active")}const s=e?.name||e?.username;console.log("当前登录用户:",s)}async logout(){try{await AuthService.logout();const e=document.getElementById("loginButton"),t=document.getElementById("registerButton");e&&(e.style.display="block"),t&&(t.style.display="block");document.getElementById("avatarDropdown").classList.remove("active"),document.getElementById("rememberPassword")?.checked||AuthService.clearRememberPassword()}catch(e){console.error("登出失败:",e)}}}console.log("Script loaded, waiting for DOMContentLoaded"),document.addEventListener("DOMContentLoaded",(()=>{console.log("DOMContentLoaded fired"),LoginManager.getInstance()}));