//# 配置文件

// 环境配置
const ENV = {
  DEVELOPMENT: "development",
  PRODUCTION: "production",
};

// 当前环境，可以根据实际打包情况来设置
let currentEnv = ENV.PRODUCTION;

// API配置
const config = {
  // API基础URL配置
  API_BASE_URL: {
    [ENV.DEVELOPMENT]: "http://localhost:3001/api",
    [ENV.PRODUCTION]: "http://111.229.24.94:3001/api",
  },

  // API超时设置（毫秒）
  TIMEOUT: 10000,

  // 存储相关的key
  STORAGE_KEYS: {
    TOKEN: "qdd_token",
    USER_INFO: "qdd_user_info",
    REMEMBER_PASSWORD: "qdd_remember_password",
    ENVIRONMENT: "qdd_environment",
    API_TIMEOUT: "qdd_api_timeout"
  },

  // 初始化配置
  async init() {
    try {
      // 从存储中获取环境设置
      const result = await chrome.storage.sync.get([
        this.STORAGE_KEYS.ENVIRONMENT,
        this.STORAGE_KEYS.API_TIMEOUT
      ]);
      
      // 设置当前环境
      if (result[this.STORAGE_KEYS.ENVIRONMENT]) {
        currentEnv = result[this.STORAGE_KEYS.ENVIRONMENT];
        console.log('从存储加载环境设置:', currentEnv);
      }
      
      // 设置超时时间
      if (result[this.STORAGE_KEYS.API_TIMEOUT]) {
        this.TIMEOUT = result[this.STORAGE_KEYS.API_TIMEOUT];
      }
      
      console.log('配置初始化完成，当前环境:', currentEnv);
      console.log('当前API基础URL:', this.API_BASE_URL[currentEnv]);
    } catch (error) {
      console.error('配置初始化失败:', error);
    }
  }
};

function getBaseUrl() {
  return config.API_BASE_URL[currentEnv];
}

// 导出配置
export default {
  ENV,
  currentEnv,
  getBaseUrl,
  ...config,
};
