// 监听插件安装事件
chrome.runtime.onInstalled.addListener(() => {
  console.log('QDD Extension installed');
});

// 监听来自content script的消息
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.type === 'getData') {
    // 处理数据请求
    sendResponse({ success: true });
  }
}); 
/** 设置sidePanel的默认路径 */
chrome.runtime.onInstalled.addListener(() => {
  if(chrome?.sidePanel){
    chrome.sidePanel.setOptions({ path: "popup/popup.html" });
    chrome.sidePanel.setPanelBehavior({ openPanelOnActionClick: true });
  }
});

chrome.action.onClicked.addListener(async function (tab) {
  try {
    // 获取当前窗口 ID
    const [currentWindow] = await chrome.windows.getCurrent();
    // 检查侧边栏是否已启用
    const isEnabled = await chrome.sidePanel.getOptions({ tabId: tab.id });
    if (!isEnabled.enabled) {
      // 启用侧边栏
      await chrome.sidePanel.setOptions({
        tabId: tab.id,
        path: "popup/popup.html" ,
        enabled: true
      });
    }
    // 打开侧边栏
    await chrome.sidePanel.open({ windowId: currentWindow.id });
  } catch (error) {
    console.error('Error opening side panel:', error);
  }
})