# QDD Browser Extension

## 简介

QDD 浏览器扩展用于提供便捷的商品管理和价格设置功能。

## 安装说明

1. 打开 Chrome 浏览器，进入扩展管理页面（chrome://extensions/）
2. 开启开发者模式
3. 点击"加载已解压的扩展程序"
4. 选择项目目录

## 开发

- 使用 `manifest.json` v3
- 支持 Chrome 浏览器
- 使用原生 JavaScript 开发

## 功能

- 用户登录管理
- 商品价格设置
- 店铺管理
- 充值中心

## 目录结构

- background/: 后台脚本 主要是用来处理插件的逻辑
- content/: 内容脚本 主要是用来处理插件的逻辑
- popup/: 弹出窗口 主要是用来显示插件的 UI
- options/: 配置页面 主要是用来配置插件的参数
- assets/: 资源文件 主要是用来存放插件的资源文件
- styles/: 样式文件 主要是用来存放插件的样式文件
- utils/: 工具函数 主要是用来存放插件的工具函数

## 项目打包说明

本项目提供了一个打包脚本，可以将项目代码打包到 dist 文件夹，并对 JavaScript、CSS 和 HTML 文件进行压缩优化。

### 打包步骤

1. **安装依赖**

   首先需要安装 Node.js 依赖包：

   ```bash
   npm install
   ```

   这将安装以下依赖：

   - terser: 用于 JavaScript 代码压缩
   - clean-css: 用于 CSS 代码压缩
   - html-minifier: 用于 HTML 代码压缩

2. **执行打包**

   运行以下命令开始打包：

   ```bash
   npm run build
   ```

   或者直接运行：

   ```bash
   node build.js
   ```

3. **打包结果**

   打包完成后，所有文件将被压缩并输出到项目根目录下的`dist`文件夹中。

   打包过程会：

   - 压缩 JavaScript 文件
   - 压缩 CSS 文件
   - 压缩 HTML 文件
   - 压缩 JSON 文件
   - 复制其他资源文件（如图片等）

### 注意事项

- 打包过程会先清空 dist 目录，再重新生成文件
- 如果某些文件压缩失败，会自动使用原始文件
- 打包完成后会显示总耗时和输出目录
